/** @file   objectivenote.h
 * @brief   Declaration of ObjectiveNote - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_OBJECTIVENOTE_H
#define H_WWW_OBJECTIVENOTE_H

#include <string>
#include "overlayitem.h"

namespace WeWantWar {

/** @class  ObjectiveNote
 * @brief   Represents the helpnote we use when showing the level objectives.
 * @author  Tomi Lamminsaari
 *
 * 
 */
class ObjectiveNote : public OverlayItem
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================

  enum {
    STATE_FADEIN,
    STATE_VISIBLE,
    STATE_FADEOUT,
    STATE_HIDDEN,
    STATE_RESTART
  };
  

  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	ObjectiveNote( int x, int y, int w, int h, const std::string& txt );


	/** Destructor
   */
	virtual ~ObjectiveNote();


private:

	/** Copy constructor.
   * @param     rO                Reference to another ObjectiveNote
   */
  ObjectiveNote( const ObjectiveNote& rO );

	/** Assignment operator
   * @param     rO                Reference to another ObjectiveNote
   * @return    Reference to us.
   */
  ObjectiveNote& operator = ( const ObjectiveNote& rO );

public:


  ///
  /// Methods
  /// =======

  /** Updates this note.
   */
  virtual void update();
  
  /** This item can be in 4 states. Fading in, visible, fading out and hidden.
   * Each state can have its own duration. This method sets the durations.
   * When this item has gone through all the states, it restarts from
   * fade in-state.
   * @param   fadein              Duration of fade in state
   * @param   visible             Duration of visible state
   * @param   fadeout             Duration of fade out state
   * @param   hidden              Duration of hidden state.
   */
  void setTimers( int fadein, int visible, int fadeout, int hidden );
  
  

  ///
  /// Getter methods
  /// ==============


protected:

  /** Updates the background buffer.
   */
  void updateBackgroundBuffer();
  
  
  
  ///
  /// Members
  /// =======

  /** Contents of this note */
  std::string m_content;
  
  /** The duration of the states */
  int m_stateDurations[4];
  
  /** The maximum opacity value */
  OverlayItem::OpacityVal m_maxOpa;
  
  /** The timer member itself. */
  int m_counter;
  
  /** The state we're in. */
  int m_state;


private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: objectivenote.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.1  2005-11-13 14:33:23+02  lamminsa
 * include file changes.
 *
 */
 
